<?php
/**
 * @package   Nicepage Website Builder
 * @author    Nicepage https://www.nicepage.com
 * @copyright Copyright (c) 2016 - 2019 Nicepage
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
defined('JPATH_BASE') or die();

/**
 * Class NicepageInstallerEvents4
 */
class NicepageInstallerEvents4 extends NicepageInstallerEvents
{
    /**
     * NicepageInstallerEvents4 constructor.
     *
     * @param object $subject Subject
     * @param array  $config  Config
     */
    public function __construct(&$subject, $config = array())
    {
        if (!$subject->hasListener([$this, 'onExtensionAfterInstall'], 'onExtensionAfterInstall')) {
            $subject->addListener('onExtensionAfterInstall', [$this, 'onExtensionAfterInstall']);
        }
        if (!$subject->hasListener([$this, 'onExtensionAfterUpdate'], 'onExtensionAfterUpdate')) {
            $subject->addListener('onExtensionAfterUpdate', [$this, 'onExtensionAfterUpdate']);
        }
        parent::__construct($subject, $config);
    }

    /**
     * On extension after install
     *
     * @param object $event
     */
    public function onExtensionAfterInstall($event)
    {
        $lang = JFactory::getLanguage();
        $lang->load('install_override', dirname(__FILE__), $lang->getTag(), true);
        $this->toplevel_installer->set('extension_message', $this->getMessages());
    }

    /**
     * On extension after update
     *
     * @param object $event
     */
    public function onExtensionAfterUpdate($event)
    {
        $lang = JFactory::getLanguage();
        $lang->load('install_override', dirname(__FILE__), $lang->getTag(), true);
        $this->toplevel_installer->set('extension_message', $this->getMessages());
    }

    /**
     * Get messages html content
     *
     * @return string
     */
    protected function getMessages()
    {
        $buffer = '<div id="nicepageinstall"><ul id="nicepageinstall-status">' . implode('', self::$messages) . '</ul></div>';

        if (file_exists(JPATH_ROOT . '/tmp/install.html')) {
            return file_get_contents(JPATH_ROOT . '/tmp/install.html') . $buffer;
        }

        return $buffer;
    }
}
